library(memisc)
library(mestats)
load("mclogit-classd.RData")

myGetSummary.classd.time <- function(x)getSummary.mclogit(x,rearrange=list(
        "Econ. L/R"=c(
                    "Squared effect"="I(econdim^2)",
                    "Linear effect"="econdim",
                    " x Intermediate/Manual worker"="econdim:classdIntermediate",
                    " x Service class/Manual worker"="econdim:classdService class",
                    " x Self-employed/Manual worker"="econdim:classdSelf-employed",
                    " x Time"="econdim:Time",
                    " x Intermediate/Manual worker x Time"="econdim:classdIntermediate:Time",
                    " x Service class/Manual worker x Time"="econdim:classdService class:Time",
                    " x Self-employed/Manual worker x Time"="econdim:classdSelf-employed:Time"
                    ),
        "Lib./auth."=c(
                    "Squared effect"="I(authlib^2)",
                    "Linear effect"="authlib",
                    " x Intermediate/Manual worker"="classdIntermediate:authlib",
                    " x Service class/Manual worker"="classdService class:authlib",
                    " x Self-employed/Manual worker"="classdSelf-employed:authlib",
                    " x Time"="Time:authlib",
                    " x Intermediate/Manual worker x Time"="classdIntermediate:Time:authlib",
                    " x Service class/Manual worker x Time"="classdService class:Time:authlib",
                    " x Self-employed/Manual worker x Time"="classdSelf-employed:Time:authlib"
                    ),
        "Mod./trad."=c(
                    "Squared effect"="I(tradmod^2)",
                    "Linear effect"="tradmod",
                    " x Intermediate/Manual worker"="classdIntermediate:tradmod",
                    " x Service class/Manual worker"="classdService class:tradmod",
                    " x Self-employed/Manual worker"="classdSelf-employed:tradmod",
                    " x Time"="Time:tradmod",
                    " x Intermediate/Manual worker x Time"="classdIntermediate:Time:tradmod",
                    " x Service class/Manual worker x Time"="classdService class:Time:tradmod",
                    " x Self-employed/Manual worker x Time"="classdSelf-employed:Time:tradmod"
                    )
        ))


(mtable.mclogit.classd <- mtable(mclogit.classd,
                                 digits=2,
                                 summary.stats=c("Dispersion","Deviance","N"),
                                 getSummary=myGetSummary.classd.time))


writeLines(
  toLatex(mtable.mclogit.classd,ddigits=-1),
  con="Table3.tex"
  )

